# SpreadShop Plugin 
#### Author: Robert Schulz
#### Contributors: Robert Schulz, Christian Lenz, Hanna Schmidt, Beatrice Thom, Stefan Drehmann, Anne Jankovics

##### Tags: spreadshirt,shop,spreadshop,shirt shop, t-shirt, spreadshirt plugin, spreadshirt shop, online shop, shop online, wordpress integration, e-commerce, merchandising
* Requires at least: 1.0
* Tested up to: 5.02
* Stable tag: 1.5.1
* License: GPLv2 or later
* License URI: http://www.gnu.org/licenses/gpl-2.0.html

This plugin integrates the Spreadshirt shop system into your WordPress instance.

# Description
Easily integrate the Spreadshop system into your WordPress blog or business page, instantly adding a powerful merchandise channel that perfectly fits the needs of your brand.

With this plugin, you can remove the manual effort of hosting a top notch ecommerce shop in WordPress while always staying up-to-date with the latest functionality and features of your Spreadshop.

Both the plugin and your Spreadshop are fully free of charge. Always.

# Our current features

* Choose from article lists or detail pages
* Take advantage of the T-shirt design tool
* Shop language support for DE, UK, US, FR, NL, NO,DK, PL, ES, IT
* Connect your shop to any marketing tool via Product Feed
* One-click Facebook Pixel and Google Analytics integration
* Support of push-state URLs to optimize shop for SEO
* Mobile-friendly
* OpenGraph & Schema.org meta tags


# What you need

* Installed WordPress instance
* Spreadshirt account

Something that we´ve missed? Read our FAQs or visit us at https://www.spreadshop.com

# Installation 

1. Download the plugin‘s *.zip file.
2. Go to the plugin menu within your WP dashboard.
3. Upload the *.zip file to your content folder.
2. Activate the plugin.

# Frequently Asked Questions 
* What is the Plugin for? =
    * The plugin seemlessly integrates your Spreadshop into any WordPress page via redirect.

* Is there a difference between a stand-alone Spreadshop and the plugin? =
    * Your Shop will look, feel, and function as usual. There’s no difference. It’ll reload within the page of your coice as soon as the Shop and the plugin settings are activated.

* Can I use the plugin for making my Shop the start page =
    * Most WordPress themes come with a pre-installed startpage layout. The plugin is not able to overwrite this setting. If you want to run the Shop under your own domain and as the start page, we recommend integrating it via Java Script, without a WordPress instance. Read more: https://help.spreadshirt.com/hc/en-us/articles/207487815-Website-Integration-with-JavaScript

* Where can I get my ShopID? =
    * Within your Spreadshirt user area you´ll find a navigation point called Sales Channels. It leads to an overview page that displays all your Shops. Each tile contains your ShopID in the upper right-hand corner. 

* Which platform am I using? =
    * Knowing the domain you used to subscribe to Spreadshop is half the battle. The following table explains which platform you´re on:
| EU  | NA |
| ------------- | ------------- |
| Deutschland (*.de)  | Vereinigte Staaten (*.com)  |
| Belgien NL (*.be/nl)  | Kanada (*.ca) |
| Belgien FR (*.be/fr)  | Kanada FR (*.ca/fr)  |
| Spanien (*.es) | Australien (*.com.au)  |
| Niederlande (*.nl)  |  |
| Polen (*.pl)  | C  |
| Schweiz IT (*.ch/it)  |   |
| Schweiz FR (*.ch/fr)  |  |
| Schweiz (*.ch) | Content Cell  |
| Frankreich (*.fr) |   |
| Irland (*ie) |   |
| Norwegen (*.no) |   |
| Finnland (*.fi) |   |
| Vereinigtes Königreich (*.co.uk) |   |
| Dänemark (*dk)	 |   |
| Italien (*.it) |   |
| Österreich (*at) |   |
| Schweden (*.se) |   |

* Which Shop URL should I enter? =
    * Please enter the page title where you’d like your Shop embedded.
    * In our example, the page is called Shop. This is where people will get to see your Shop. https://www.yourbrandpage.com/shop
    * Copy the full URL and paste it into  your Shop settings under: Advanced Settings > Embed Shop in Website

* How to use the Start Token Setting? =
    * You can define a specific page of your Shop that will be loaded in your WordPress page (this could be the detail page/topic overview or a list page, each filtered for a certain product type.) These settings only influence the integrated Shop and nothing on shop.spreadshirt.de/shopname.

* What is the MetaData setting about? =
    * If you have the Spreadshop plugin running on your website, the relevant integrated SEO meta data changes in your site’s header (title, description and SEO-Index, as well as OpenGraph and Twitter card tags). By unchecking the box, you'll switch this feature off, and your site`s SEO meta data will then be used.

* How to use the Language setting? =
    * If your Spreadshop has the "All Languages active" setting enabled, you can define a specific language and currency for your integrated Shop. If you define nothing, the shop's default language and currency will be used.

* What is the Swipe Menu setting? =
    * If your WordPress page uses a burger menu on mobile devices, we advise you to enable this feature. By doing this, the shop's mobile menu will turn into a swipeable navigation bar (as opposed to a second burger menu).

* Where can I get detailed support? =
    * There´s probably someone out there that had exactly the same question and is filled up with wisdom to answer all your requests. Visit our forum and get to know other Shop Owners who can help. There´s one for each platform:
    * EU: https://www.spreadshirt.net/forum
    * NA: https://www.spreadshirt.com/forum

* What If I deactivate the plugin? =
    * If you deactiate the plugin, the redirect from our Shop URL stops working. The shop will no longer be visible for your fans and customers under your personalized domain. It will still be reachable via its standard https://shop.spreadshirt.xyz/yourshopname URL.

* How do I uninstall the plugin? =
    * We believe this won´t happen... but if you really need to:
1. Go to your WP plugin section.
2. Mark the Spreadshop plugin and choose delete from the dropdown menu.
3. Then hit apply.


# Upgrade Notice

## Changelog 

#### 1.5.1
* New feature: possibility of shortcode insertion
* New feature: possibility to remove hashbang from URLs
* Change: Edit-button in the modul is shown as button and no longer als mouse-over

#### 1.5.0
* change styling in settings menu / update content text

#### 1.4.8
* added FAQ link and change styling for buttons

#### 1.4.7
* added SpreadShop SwipeMenu option

#### 1.4.6
* added/refactored SpreadShop Country selection

#### 1.4.5
* added SpreadShop Metadata option

#### 1.4.4
* added SpreadShop Token option

#### 1.4.3
* changed visual styles of backend SpreadShop settings
* changed backend main picture
* small improvements

#### 1.4.2 
* fixed internal platform selection bug

#### 1.4.1 
* fixed missing title bug

#### 1.4 
* internationalization fixes

#### 1.3.1 
* well, no changes again only trying to figure out what went wrong in the release process

#### 1.3 
* any reference to altering the main navigation was removed as it caused severe issues with some templates

#### 1.2 
* integrated better language/locale support to prevent, that shops show up empty
* added the js files that got lost in tag 1.1.1

#### 1.1.1 
* fixed problems with setup of shop data that stood in conflice to other plugins
* css fix for the backend to only display "edit settings" on request

#### 1.1 
* Added option to change settings w/o reinitializing plugin
* Added opttion to define top padding for shop in case navigation of theme conflicts with shop

#### 1.0 
* Initial release for the plugin MVP.
* Features definition of shopID and platform to integrate a SpreadShop into your WordPress instance.

