<?php

/*
Plugin Name: SpreadShop
Plugin URI: http://URI_Of_Page_Describing_Plugin_and_Updates
Description: This plugin intecrates a Spreadshirt Shop into Wordpress.
Version: 1.5.1
Author: Robert Schulz (sprd.net AG)
Co-Author: Stefan Drehmann (IronShark GmbH)
Author URI: http://rschulz.me/t-shirt-shop
Co-Author URI: https://www.ironshark.de
License: GPL2
*/

include "spreadshop_options.php";
add_action('admin_menu', 'spreadshop_admin_menu');
add_action( 'update_option_spreadshopID', 'init_spreadshop');
add_action('admin_init','register_spreadshop_settings');
add_action( 'activated_plugin', 'spreadshop_activation_redirect' );
add_filter( 'template_include', 'spreadshop_page_template',99 );
register_deactivation_hook( __FILE__, 'spreadshop_deactivate' );

function register_spreadshop_settings(){
    register_setting( 'spreadshop-settings-group', 'spreadshopID' );
    register_setting( 'spreadshop-settings-group', 'spreadshopToken' );
    register_setting( 'spreadshop-settings-group', 'spreadshopPlatform');
    register_setting( 'spreadshop-settings-group', 'spreadshopInitialized' );
    register_setting( 'spreadshop-settings-group', 'spreadshopSlug');
    register_setting( 'spreadshop-settings-group', 'spreadshopOptimizeUrl');
    register_setting( 'spreadshop-settings-group', 'spreadshopOptimizeUrlCheck');
    register_setting( 'spreadshop-settings-group', 'spreadshopMetadata');
    register_setting( 'spreadshop-settings-group', 'spreadshopMetadataCheck');
    register_setting( 'spreadshop-settings-group', 'spreadshopSwipeMenu');
    register_setting( 'spreadshop-settings-group', 'spreadshopSwipeMenuCheck');
    register_setting( 'spreadshop-settings-group', 'spreadshopLocale');
    register_setting( 'spreadshop-settings-group', 'spreadshopNaviEntry');
    add_option('spreadshopID','undefined');
}

function spreadshop_page_template($template){

    if(strpos($_SERVER["REQUEST_URI"], get_option('spreadshopSlug'))){

        if(get_option('spreadshopToken')) {

          $cookie_token = "sprdCookieToken";
          $cookie_token_value = get_option('spreadshopToken');
          setcookie($cookie_token, $cookie_token_value, time() + (86400 * 30), "/");

          $cookie_url = "sprdCookieUrl";
          $cookie_url_value = get_option('spreadshopSlug');
          setcookie($cookie_url, $cookie_url_value, time() + (86400 * 30), "/");

        } else {

          if (isset($_COOKIE['sprdCookieToken'])) {

            unset($_COOKIE['sprdCookieToken']);
            setcookie('sprdCookieToken', '', time() - 3600, '/');
          }

          if (isset($_COOKIE['sprdCookieUrl'])) {

            unset($_COOKIE['sprdCookieUrl']);
            setcookie('sprdCookieUrl', '', time() - 3600, '/');
          }
        }

        wp_register_script( 'spreadshop_config', plugins_url('js/spreadshop_config.js', __FILE__));
        $tld = get_option('spreadshopPlatform') == 'EU' ? 'net' : 'com';
        $config_array = array(
            'spreadshopID' => get_option('spreadshopID'),
            'spreadshopToken' => get_option('spreadshopToken'),
            'spreadshopOptimizeUrl' => get_option('spreadshopOptimizeUrl'),
            'spreadshopMetadata' => get_option('spreadshopMetadata'),
            'spreadshopSwipeMenu' => get_option('spreadshopSwipeMenu'),
            'spreadshopTLD' => $tld,
            'spreadshopLocale' => get_option('spreadshopLocale')
        );
        wp_localize_script( 'spreadshop_config', 'spreadshop_config_data', $config_array );
        status_header(200);
        wp_enqueue_script( 'spreadshop_config' );
        wp_enqueue_script( 'spreadshop_js_sources', esc_url_raw( '//shop.spreadshirt.'.$tld.'/shopfiles/shopclient/shopclient.nocache.js' ));
        $plugin_path = plugin_dir_path( __FILE__ );
        $template_name = 'spreadshop-page-template.php';
        return $plugin_path . $template_name;
    }
    return $template;
}

function spreadshop_admin_menu(){
    add_menu_page("SpreadShop", "SpreadShop", "manage_options", "SpreadShop", "spreadshop_options","dashicons-cart",99);
}

function spreadshop_activation_redirect() {
    exit( wp_redirect( admin_url( 'options-general.php?page=SpreadShop' ) ) );
}

function spreadshop_deactivate() {
    delete_option('spreadshopID');
    delete_option('spreadshopToken');
    delete_option('spreadshopPlatform');
    delete_option('spreadshopInitialized');
    delete_option('spreadshopSlug');
    delete_option('spreadshopOptimizeUrl');
    delete_option('spreadshopOptimizeUrlCheck');
    delete_option('spreadshopMetadata');
    delete_option('spreadshopMetadataCheck');
    delete_option('spreadshopSwipeMenu');
    delete_option('spreadshopSwipeMenuCheck');
    delete_option('spreadshopLocale');
}

function init_spreadshop() {
    wp_redirect(admin_url( 'admin.php?page=SpreadShop'));
}

/**
 * This is the Shortcode function to implement the shop in each Page
 */
function spreadshopShortcode($atts) {

    // Shortcode may only run one time
    static $already_run = false;
    if ( $already_run !== true ) {

        // get deeplink as startToken
        $a = shortcode_atts(
            array(
                'deeplink' => get_option('spreadshopToken'),
            ), $atts
        );

        wp_register_script( 'spreadshop_config', plugins_url('js/spreadshop_config.js', __FILE__));
        $tld = get_option('spreadshopPlatform') == 'EU' ? 'net' : 'com';
        $config_array = array(
            'spreadshopID' => get_option('spreadshopID'),
            'spreadshopToken' => $a['deeplink'],
            'spreadshopMetadata' => get_option('spreadshopMetadata'),
            'spreadshopSwipeMenu' => get_option('spreadshopSwipeMenu'),
            'spreadshopTLD' => $tld,
            'spreadshopLocale' => get_option('spreadshopLocale'),
            'spreadshopOptimizeUrl' => get_option('spreadshopOptimizeUrl')
        );

        wp_localize_script( 'spreadshop_config', 'spreadshop_config_data', $config_array );
        status_header(200);
        wp_enqueue_script( 'spreadshop_config');
        wp_enqueue_script( 'spreadshop_js_sources', esc_url_raw( '//shop.spreadshirt.'.$tld.'/shopfiles/shopclient/shopclient.nocache.js' ));

        // Content Output
        $shop_output = '<div id="primary" class="content-area" >'
            . '<main id="main" class="site-main">'
            .    '<div id="myShop"></div>'
            . '</main><!-- #main -->'
            . '</div><!-- #primary -->';
        return $shop_output;
    }
    $already_run = true;
}

add_shortcode('spreadshop', 'spreadshopShortcode');
