<?php

function spreadShop_options(){
    wp_enqueue_style('spreadShopOptionsStyle', plugins_url('style/style.css', __FILE__));
    wp_enqueue_script('spreadShopOptionsScript', plugins_url('js/spreadshop_admin.js', __FILE__));

    $platforms = array(
        "EU",
        "NA"
    );

    $locales = array(
        "EU" => array(
            "Region" => "",
            "Danmark" => "da_DK",
            "Europe" =>"en_EU",
            "Ireland" => "en_IE",
            "United Kingdom " => "en_GB",
            "Deutschland" => "de_DE",
            "Österreich" => "de_AT",
            "Schweiz (Deutsch)" => "de_CH",
            "Suisse (Francais)" => "fr_CH",
            "Svizzera (Italiano) " => "it_CH",
            "Espana" => "es_ES",
            "Suomi" => "fi_FI",
            "France" => "fr_FR",
            "Belgique (Francais)" => "fr_BE",
            "Italia" => "it_IT",
            "Belgie (Nederlands)" => "nl_BE",
            "Nederland" => "nl_NL",
            "Norge" => "no_NO",
            "Polska" => "pl_PL",
            "Sverige" => "sv_SE",
        ),
        "NA" => array(
            "Region" => "",
            "United States " => "en_US",
            "Canada (English)" => "en_CA",
            "Canada (Francais)"  => "fr_CA",
            "Australia"  => "en_AU"
        )
    )

?>
<div class="spreadShopAdminWrapper">
    <div class="settingsContainer">
        <div class="left">
            <div class="pluginHeadline"></div>
        </div>
        <div class="right">
            <?php if (get_option('spreadshopInitialized') == false) {?>
                <h1>Shop activation </h1>
                <span>Welcome to the SpreadShop Wordpress plugin - the simplest plugin ever to integrate the Spreadshirt shop system into Wordpress. </span>
                <form method="post" action="options.php">
                    <?php settings_fields( 'spreadshop-settings-group' ); ?>
                    <?php do_settings_sections( 'spreadshop-settings-group' ); ?>
                    <table class="shopSettingsContainer">
                        <tr>
                            <td class="shopSettings__heading" colspan="100%">Settings</td>
                        </tr>
                        <tr>
                            <td class="shopSettings__divider" colspan="100%"></td>
                        </tr>
                        <tr>
                            <th scope="row">ShopID</th>
                            <td><input type="text" name="spreadshopID" value="<?php echo esc_attr( get_option('spreadshopID') ); ?>" /></td>
                        </tr>
                        <tr>
                            <th scope="row">Platform</th>
                            <td><select id="platform" name="spreadshopPlatform" value="<?php echo esc_attr( get_option('spreadshopPlatform') ); ?>"/><option>EU</option><option>NA</option></select> </td>
                        </tr>

                        <tr>
                            <th scope="row">Shop URL</th>
                            <td><?php echo get_site_url().'/'.get_option('spreadshopSlug');?><input type="text" id="slug" name="spreadshopSlug" value="t-shirt-shop"/> </td>
                        </tr>

                        <input type="hidden" name="spreadshopMetadata" value="1" />
                        <input type="hidden" name="spreadshopMetadataCheck" value="1">
                        <input type="hidden" name="spreadshopInitialized" value="1">

                    </table>
                    <?php submit_button(); ?>
                </form>
                <h3>No shop yet</h3>
                <span><a href="https://www.spreadshirt.com/start-selling-shirts-C3598">Register now!</a></span>

            <?php } else{?>
                <h1>Your Wordpress Plugin Is Ready!</h1>
                <div class="editable">
                    <table class="shopSettingsContainer editable">
                        <tr>
                            <td class="shopSettings__heading" colspan="100%">Settings</td>
                        </tr>
                        <tr>
                            <td class="shopSettings__divider" colspan="100%"></td>
                        </tr>
                        <tr>
                            <th scope="row">ShopID</th>
                            <td><span> <?php echo esc_attr( get_option('spreadshopID') ); ?></span></td>
                        </tr>
                        <tr>
                            <th scope="row">Platform</th>
                            <td><span><?php echo esc_attr( get_option('spreadshopPlatform') ); ?></span></td>
                        </tr>
                        <tr>
                            <th scope="row">Shop URL</th>
                            <td><span><?php echo get_site_url().'/'.get_option('spreadshopSlug');?></td>
                        </tr>
                    </table>
                    <button class="btn-edit button-primary" id="spreadShopChangeSettings">Edit</button>
                </div>


                <a class="btn-grey" href="<?php

                    if(!empty(get_option('spreadshopToken'))) {
                      echo(get_site_url().'/'.get_option('spreadshopSlug').'/#!/'.get_option('spreadshopToken'));
                    } else {
                      echo(get_site_url().'/'.get_option('spreadshopSlug'));
                    }
                    ?>" target="_blank">Preview Shop</a>
                <a class="btn-grey" href="https://partner.spreadshirt.<?php echo(get_option( 'spreadshopPlatform' ) == 'EU' ? 'net' : 'com'); ?>" target="_blank">Login at Spreadshirt</a>
                <div>
                    <a class="btn-secondary" href="https://wordpress.org/plugins/spreadshop/ " target="_blank">Read more in our FAQ ></a>
                </div>
                <div  class="spreadShopSettingChange" id="spreadShopSettingsEdit">
                    <form method="post" action="options.php">
                        <?php settings_fields( 'spreadshop-settings-group' ); ?>
                        <?php do_settings_sections( 'spreadshop-settings-group' ); ?>
                        <table class="shopSettingsContainer__settings-edit">
                            <tr>
                                <td class="shopSettings__heading" colspan="100%">Settings</td>
                            </tr>
                            <tr>
                                <th scope="row" style="width: 254px">Essential Settings (required)</th>
                            </tr>
                            <tr>
                                <td class="shopSettings__divider" colspan="100%"></td>
                            </tr>
                            <tr>
                                <th scope="row">ShopID</th>
                                <td><input type="text" name="spreadshopID" value="<?php echo esc_attr( get_option('spreadshopID') ); ?>" /></td>
                            </tr>
                            <tr>
                                <th scope="row">Platform</th>
                                <td>
                                    <select id="platform" name="spreadshopPlatform" />
                                        <?php foreach ($platforms as $platform) {
                                        if ($platform == get_option('spreadShopPlatform')) {
                                        echo('<option selected="selected" value="'.$platform.'">'.$platform.'</option>');
                                        } else {
                                        echo('<option value='.$platform.'>'.$platform.'</option>');
                                        }
                                        }?>
                                    </select>
                                </td>
                            </tr>
                            <tr rowspan="2">
                                <th scope="row">Shop URL</th>
                                <td>
                                    <div>
                                        <?php echo get_site_url().'/'.get_option('spreadshopSlug');?>
                                    </div>
                                    <div>
                                        <input type="text" id="slug" name="spreadshopSlug" value="<?php echo get_option('spreadshopSlug');?>"/>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <th scope="row">Additional Settings</th>
                            </tr>
                            <tr>
                                <td class="shopSettings__divider" colspan="100%"></td>
                            </tr>
                            <tr>
                                <th scope="row">Start Token <br>
                                    <span>URL tail that leads to your Shop</span>
                                </th>
                                <td><input id="spreadshopToken" type="text" name="spreadshopToken" value="<?php echo esc_attr( get_option('spreadshopToken') ); ?>" /></td>
                            </tr>

                            <tr>
                                <th scope="row">Optimize Url</th>
                                <td>
                                    <?php
                                    
                                        if(get_option('spreadshopOptimizeUrlCheck') == ''){
                                            update_option('spreadshopOptimizeUrlCheck','1');
                                            update_option('spreadshopOptimizeUrl','1');
                                            $spreadshopOptimizeUrl = get_option('spreadshopOptimizeUrl');
        
                                            echo '<input
                                                    type="checkbox"
                                                    id="spreadshopOptimizeUrl"
                                                    name="spreadshopOptimizeUrl"
                                                    value='.$spreadshopOptimizeUrl.'
                                                    checked />';
                                        } elseif (get_option('spreadshopOptimizeUrlCheck') == '1') {
                                            update_option('spreadshopOptimizeUrl','1');
                                            $spreadshopOptimizeUrl = get_option('spreadshopOptimizeUrl');
        
                                            echo '<input
                                                    type="checkbox"
                                                    id="spreadshopOptimizeUrl"
                                                    name="spreadshopOptimizeUrl"
                                                    value='.$spreadshopOptimizeUrl.'
                                                    checked />';
                                        } else {
                                            update_option('spreadshopOptimizeUrl','0');
                                            $spreadshopOptimizeUrl = get_option('spreadshopOptimizeUrl');
        
                                            echo '<input
                                                    type="checkbox"
                                                    id="spreadshopOptimizeUrl"
                                                    name="spreadshopOptimizeUrl"
                                                    value='.$spreadshopOptimizeUrl.'
                                                    />';
                                        }
                                    
                                    ?>
                                    <input type="hidden" id="spreadshopOptimizeUrlCheck" name="spreadshopOptimizeUrlCheck" value="<?php echo get_option('spreadshopOptimizeUrlCheck')?>">
                                </td>
                            </tr>

                            <tr>
                                <th scope="row">Meta Data</th>
                                <td>
                                    <?php
                                      if (get_option('spreadshopMetadataCheck') == '1') {

                                        update_option('spreadshopMetadata','1');
                                        $spreadshopMetadata = get_option('spreadshopMetadata');

                                        echo '<input type="checkbox" id="spreadshopMetadata" name="spreadshopMetadata" value='.$spreadshopMetadata.' checked />';

                                      } else {

                                        update_option('spreadshopMetadata','0');
                                        $spreadshopMetadata = get_option('spreadshopMetadata');

                                        echo '<input type="checkbox" id="spreadshopMetadata" name="spreadshopMetadata" value='.$spreadshopMetadata.' />';
                                      }
                                    ?>
                                    <input type="hidden" id="spreadshopMetadataCheck" name="spreadshopMetadataCheck" value="<?php echo get_option('spreadshopMetadataCheck')?>">
                                </td>
                            </tr>

                            <tr>
                                <th scope="row">Mobile Swipe Menu</th>
                                <td>
                                    <?php
                                      if (get_option('spreadshopSwipeMenuCheck') == '1') {

                                        update_option('spreadshopSwipeMenu','1');
                                        $spreadshopSwipeMenu = get_option('spreadshopSwipeMenu');

                                        echo '<input type="checkbox" id="spreadshopSwipeMenu" name="spreadshopSwipeMenu" value='.$spreadshopSwipeMenu.' checked />';

                                      } else {

                                        update_option('spreadshopSwipeMenu','0');
                                        $spreadshopSwipeMenu= get_option('spreadshopSwipeMenu');

                                        echo '<input type="checkbox" id="spreadshopSwipeMenu" name="spreadshopSwipeMenu" value='.$spreadshopSwipeMenu.' />';
                                      }
                                    ?>
                                    <input type="hidden" id="spreadshopSwipeMenuCheck" name="spreadshopSwipeMenuCheck" value="<?php echo get_option('spreadshopSwipeMenuCheck')?>">
                                </td>
                            </tr>

                            <tr>
                                <th scope="row">Region</th>
                                <td>
                                    <select id="platform-language" name="spreadshopLocale" />
                                      <?php
                                          foreach ($platforms as $platform) {

                                            if ($platform == get_option('spreadShopPlatform')) {

                                              foreach ($locales as $locale_key => $locale_language) {

                                                if ($locale_key != get_option('spreadShopPlatform')) {
                                                  unset($locales[$locale_key]);
                                                  continue;
                                                }

                                                foreach($locale_language as $language => $locale) {
                                                  if ($locale == get_option('spreadshopLocale')) {
                                                    echo('<option selected="selected" value="'.$locale.'">'.$language.'</option>');
                                                  } else {
                                                    echo('<option value='.$locale.'>'.$language.'</option>');
                                                  }
                                                }
                                              }
                                            }
                                          }
                                      ?>
                                    </select>
                                </td>
                            </tr>
                            <input type="hidden" name="spreadshopInitialized" value="1">
                        </table>

                        <div class="btn-secondary-container">
                            <p>Instead of the Shop URL you can use the shortcode <strong>[spreadshop]</strong> to integrate the shop on a page.</p>
                            <a class="btn-secondary" href="https://wordpress.org/plugins/spreadshop/ " target="_blank">Read more in our FAQ ></a>
                        </div>
                        <?php submit_button( "Save Changes"); ?>
                    </form>
                </div>
            <?php };?>
        </div>
    </div>
</div>
<?php };